Attribute VB_Name = "Workplane"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.

Function menuPlaneOfObject()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim FaceSet As ObjectSet
Set FaceSet = activePart.GetSelection("Geometric")

Dim faceSetIt As iterator
Set faceSetIt = prod.GetClass("It").CreateAObjectIt(FaceSet)

If (FaceSet.IsEmpty) Then
    MsgBox "Faces not Selected"
    Exit Function
End If

If (FaceSet.GetAnyMember.IsA("Geometric")) Then

    If (FaceSet.GetCount = 1) Then
    
        If (faceSetIt.start.GetGeometricForm.IsA("Plane") Or faceSetIt.start.GetGeometricForm.IsA("Circle")) Then
            Dim refplane1 As aWorkplane
            Set refplane1 = cfobject.PlaneOfObject(faceSetIt.start, "demoWorkPlane" & CStr(WorkplaneCount), "demoSketch" & CStr(SketchCount), False, 9)
            SketchCount = SketchCount + 1
            WorkplaneCount = WorkplaneCount + 1
        Else
        MsgBox "The Selected Face is not Planar"
        Exit Function
        End If
            
    Else
    MsgBox "Select only one face"
    Exit Function
    End If
            
Else
MsgBox "Entities selected are not Faces"
Exit Function
End If

api.CommitCalls "PlaneOfObject", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function

Function menuPlaneThroughObjects()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim edgeSet As ObjectSet
Set edgeSet = activePart.GetSelection("Geometric")

Dim edgeSetIt As iterator
Set edgeSetIt = prod.GetClass("It").CreateAObjectIt(edgeSet)

If (edgeSet.IsEmpty) Then
    MsgBox "Edges not Selected"
    Exit Function
End If

If (edgeSet.GetAnyMember.IsA("Geometric")) Then

    If (edgeSet.GetCount = 2) Then
    
        Set topo = edgeSetIt.start
        
        'For I = 0 To edgeSet.GetCount - 1
        Do While edgeSetIt.IsActive
            Set topo = edgeSetIt.Current
            If (Not (topo.GetGeometricForm.IsA("Straight"))) Then
                MsgBox "Not all Edges selected are Straight"
                Exit Function
            End If
            edgeSetIt.Next
        Loop
        'Next I
        
         Dim edge1 As aGeometric
         Dim edge2 As aGeometric
         
         Set edge1 = edgeSetIt.start
         
         Do While edgeSetIt.IsActive
            Set edge2 = edgeSetIt.Current
            edgeSetIt.Next
         Loop
        
        If (edge1.GetGeometricForm.GetDirection.IsParallel(edge2.GetGeometricForm.GetDirection, False)) Then
            Set planethruobjects1 = cfobject.PlaneThroughObjects(edge1, edge2, "demoWorkPlane" & CStr(WorkplaneCount), "demoSketch" & CStr(SketchCount), False, 9)
            SketchCount = SketchCount + 1
            WorkplaneCount = WorkplaneCount + 1
        Else
            MsgBox "Plane through selected edges not possible"
            Exit Function
        End If
        
    Else
        MsgBox "More than two edges selected"
    End If
    
Else
MsgBox "Entities selected are not Edges"
End If

api.CommitCalls "PlaneThroughObjects", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function

Function menuMidPlane()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim FaceSet As ObjectSet
Set FaceSet = activePart.GetSelection("Geometric")

Dim faceSetIt As iterator
Set faceSetIt = prod.GetClass("It").CreateAObjectIt(FaceSet)

If (FaceSet.IsEmpty) Then
    MsgBox "Faces/Workplanes not Selected"
    Exit Function
End If

If (FaceSet.GetAnyMember.IsA("Face") Or FaceSet.GetAnyMember.IsA("Workplane")) Then

    If (FaceSet.GetCount = 2) Then
        
        Set checkFace = faceSetIt.start
        For I = 0 To FaceSet.GetCount - 1
        If (Not (checkFace.GetGeometricForm.IsA("Plane"))) Then
            MsgBox "Not all Faces selected are Planar"
            Exit Function
        End If
        Set checkFace = faceSetIt.Next
        Next I
        
        Dim face1 As aGeometric
        Dim face2 As aGeometric
        Set face1 = faceSetIt.start
        Set face2 = faceSetIt.Next
         
        If (face1.GetGeometricForm.GetDirection.IsParallel(face2.GetGeometricForm.GetDirection, False)) Then
            Dim midplane1 As aWorkplane
            Set midplane1 = cfobject.MidPlanePart(face1, face2, "demoWorkPlane" & CStr(WorkplaneCount), "demoSketch" & CStr(SketchCount), False, 9)
            SketchCount = SketchCount + 1
            WorkplaneCount = WorkplaneCount + 1
        Else
            MsgBox "MidPlane through Selected Faces/Workplane not possible"
            Exit Function
        End If
        
    Else
        MsgBox "More than two entities selected"
    End If
    
Else
MsgBox "Entities selected are not Faces or Workplanes"
End If

api.CommitCalls "MidPlanePart", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function

Function menuOffsetPlane()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim FaceSet As ObjectSet
Set FaceSet = activePart.GetSelection("Geometric")

Dim faceSetIt As iterator
Set faceSetIt = prod.GetClass("It").CreateAObjectIt(FaceSet)

If (FaceSet.IsEmpty) Then
    MsgBox "Faces/Workplanes not Selected"
    Exit Function
End If

If (FaceSet.GetAnyMember.IsA("Face") Or FaceSet.GetAnyMember.IsA("Workplane")) Then

    If (FaceSet.GetCount = 1) Then
    
        If (Not (faceSetIt.start.GetGeometricForm.IsA("Plane"))) Then
        MsgBox "The Face selected is not Planar"
        Exit Function
        End If
                
        Dim offsetplane1 As aWorkplane
        Set offsetplane1 = cfobject.OffsetPlane(faceSetIt.start, 0.1, "demoWorkplane" & CStr(WorkplaneCount), "demoSketch" & CStr(SketchCount), False, 9)
        SketchCount = SketchCount + 1
        WorkplaneCount = WorkplaneCount + 1
                
    Else
        MsgBox "More than one entity selected"
    End If
    
Else
MsgBox "Entity selected is not a Face or Workplane"
End If

api.CommitCalls "OffsetPlane", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function

Function menuOrientedPlane()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim edgeSet As ObjectSet
Set edgeSet = activePart.GetSelection("Geometric")

Dim edgeSetIt As iterator
Set edgeSetIt = prod.GetClass("It").CreateAObjectIt(edgeSet)

If (edgeSet.IsEmpty) Then
    MsgBox "Edge/Line not selected not Selected"
    Exit Function
End If

If (edgeSet.GetAnyMember.IsA("Geometric")) Then
    If (edgeSet.GetCount = 1) Then
        If (edgeSetIt.start.GetGeometricForm.IsA("Straight")) Then
            Pi = 3.14159265359
            On Error GoTo ErrHandler
            Dim geom As aGeometric
            Set geom = edgeSetIt.start
            Dim orientedplane1 As aWorkplane
            Set orientedplane1 = cfobject.OrientedPlane(geom, Pi / 4, "demoWorkPlane" & CStr(WorkplaneCount), "demoSketch" & CStr(SketchCount), False, 8)
            SketchCount = SketchCount + 1
            WorkplaneCount = WorkplaneCount + 1
        Else
            MsgBox "The Selected Edge is not Straight"
            Exit Function
        End If
    Else
        MsgBox "Select only one Edge"
        Exit Function
    End If
Else
    MsgBox "Entity selected is not a Face"
    Exit Function
End If

api.CommitCalls "OrientedPlane", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function
ErrHandler:
        MsgBox ("An error has occured while creating an Oriented Plane")
        Exit Function
    
End Function


Function menuRepositionAxes()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

cfobject.RepositionAxes 0.05, 0.05, 0

api.CommitCalls "RepositionAxes", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function


Function menuRotateAxes()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

cfobject.RotateAxes 45

api.CommitCalls "RotateAxes", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function


Function menuTranslateAxes()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

cfobject.TranslateAxes -0.05, -0.05

api.CommitCalls "TranslateAxes", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function




Function menuReverseAxes()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

cfobject.ReverseAxes

api.CommitCalls "ReverseAxes", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function


Function menuNewSketch()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0


Dim wpNewSketch As aWorkplane
Set wpNewSketch = activePart.GetActiveWorkplane()

Dim tempSk As aSketch
Set tempSk = cfobject.NewSketch(wpNewSketch, 9, "demoSketch" & CStr(SketchCount))
SketchCount = SketchCount + 1

api.CommitCalls "NewSketch", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function


Function menuHideOtherSketches()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()
If activePart Is Nothing Then
    MsgBox "Could not get the Active Part", vbExclamation, "Error"
    Exit Function
End If

Dim wpNewSketch As aWorkplane
Set wpNewSketch = activePart.GetActiveWorkplane()

cfobject.HideOtherSketches

api.CommitCalls "HideOtherSketches", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function









